from typing import Set, Union

from django.db import models

from apadata.models import Keyword
from apadata.text_processors.keywords.synonymy_finder import SynonymyFinder
from apadata.text_processors.text_embedder_processor import TextEmbedderProcessor
from apadata.utils import flatten


class SynonymyFinderEnricher(SynonymyFinder):
    """Finds synonyms of a word, if any of those synonyms are already present in the
    database as different entries, then they are discarded"""

    def __init__(self, text: str):
        super().__init__(text)

    def process(self) -> Union[str, Set[str]]:
        synonyms = super().process()
        new_keywords = []
        for synonym in synonyms:
            try:
                Keyword.objects.get(name__iexact=synonym)
            except (models.ObjectDoesNotExist, Keyword.DoesNotExist):
                Keyword.objects.create(
                    name=synonym,
                    embedding=list(flatten(TextEmbedderProcessor(synonym).process())),
                )
                new_keywords.append(synonym)
        return set(new_keywords)
