from typing import Any

from apadata.text_processors.keywords.case_insensitive_finder import (
    CaseInsensitiveFinder,
)


class CaseInsensitiveFinderReducer(CaseInsensitiveFinder):
    """
    This class will find keywords which are identical after lower casing
    """

    def __init__(self, text: str):
        super().__init__(text)

    def process(
        self,
    ) -> Any:
        super().process()
        cases_format, keyword_objects = super().process()
        if len(cases_format["title"]):
            kept_keyword = cases_format["title"][0]
        elif len(cases_format["upper"]):
            kept_keyword = cases_format["upper"][0]
        else:
            kept_keyword = cases_format["lower"][0]
        for i, keyword_object in enumerate(keyword_objects):
            if keyword_object.name != kept_keyword:
                keyword_objects[i].discarded = True
                keyword_objects[i].discarded_reason = "case_insensitive_finder"
            keyword_objects[i].save()
        return str(kept_keyword)
