from apadata.models import Keyword
from apadata.text_processors import TextProcessor
from apadata.text_processors.text_embedder_processor import TextEmbedderProcessor


class CrossTranslatorReducer(TextProcessor):
    """
    This class will translate the given keyword from the language in which it is
    written into english, if it exists already in english the english variant will be
    kept and the one in another language other than english will be discarded
    """

    languages = ["en", "de"]

    def __init__(self, text: str):
        super().__init__(text)
        if not Keyword.objects.filter(name=self.text).exists():
            self.keyword_obj = Keyword.objects.create(
                name=self.text, embedding=TextEmbedderProcessor(self.text).process()
            )
        else:
            self.keyword_obj = Keyword.objects.get(name=self.text)

    def process(self) -> str:
        super().process()
        kept_keyword = self.text
        keywords = Keyword.objects.filter(
            en_translation__iexact=self.keyword_obj.en_translation
        )
        non_en_keywords = keywords.exclude(language="en")
        discarded_keywords = (
            non_en_keywords
            if len(keywords) != len(non_en_keywords)
            else non_en_keywords[1:]
        )
        for keyword_obj in discarded_keywords:
            keyword_obj.discarded = True
            keyword_obj.discarded_reason = "cross_translator"
            keyword_obj.save()
        return kept_keyword
