from django.db import models

from apadata.models import Acronym, Keyword
from apadata.text_processors import TextProcessor
from apadata.text_processors.keywords.deacronymizer import Deacronymizer


class DeacronymizerReducer(Deacronymizer):
    def __init__(self, text: str):
        super().__init__(text)

    def process(self) -> str:
        super().process()
        # quite unlikely to be acronym if it is longer than 7 characters
        if len(self.text) > 7:
            return self.text
        try:
            acronym_obj = Keyword.objects.get(name=self.text)
        except (models.ObjectDoesNotExist, Keyword.DoesNotExist):
            return self.text
        try:
            deacronymized = str(Acronym.objects.get(acronym=self.text).full_form)
        except (models.ObjectDoesNotExist, Acronym.DoesNotExist):
            return self.text
        if deacronymized == self.text:
            return self.text
        try:
            Keyword.objects.get(name__iexact=deacronymized)
        except (models.ObjectDoesNotExist, Keyword.DoesNotExist):
            return self.text
        acronym_obj.discarded = True
        acronym_obj.discarded_reason = "deacronymizer"
        acronym_obj.save()
        return deacronymized
