from django.db import models

from apadata.models import Keyword
from apadata.text_processors.keywords.synonymy_finder import SynonymyFinder


class SynonymyFinderReducer(SynonymyFinder):
    """Finds synonyms of a word, if any of those synonyms are already present in the
    database as different entries, then they are discarded"""

    def __init__(self, text: str):
        super().__init__(text)

    def process(self) -> str:
        synonyms = super().process()
        for synonym in synonyms:
            try:
                keyword_obj = Keyword.objects.get(name__iexact=synonym)
            except (models.ObjectDoesNotExist, Keyword.DoesNotExist):
                continue
            keyword_obj.discarded = True
            keyword_obj.discarded_reason = "synonymy_finder"
            keyword_obj.save()
        return self.text
