from typing import Optional, Set

from django.db import models
from django.db.models import Q

from apadata.models import Keyword, SimilarKeywords
from apadata.text_processors import TextProcessor
from apadata.text_processors.text_embedder_processor import TextEmbedderProcessor
from apadata.utils import flatten
from apadata.vectordb.vectordb_api import VectorDBAPI


class SimilarityFinder(TextProcessor):
    """
    This class will find the synonyms for a word
    """

    def __init__(self, text: str, similarity_threshold: float = 0.75, top_k: int = 10):
        super().__init__(text)
        self.similarity_threshold = similarity_threshold
        self.top_k = top_k

    def process(self):
        pass
