from apadata.strategies.score_strategy import ScoreStrategyEnum
from apadata.text_processors.evaluators.synonymy_evaluator import SynonymyEvaluator
from apadata.text_processors.text_similarity import load_industry_names_embs


def test_synonymy_evaluator():
    evaluator = SynonymyEvaluator(
        strategy=ScoreStrategyEnum(ScoreStrategyEnum.HIGHEST),
        industry_name_embs=load_industry_names_embs(),
    )
    keyword = "Consulting"
    result = round(
        evaluator.evaluate(keyword),
        4,
    )
    assert isinstance(result, float)
    assert result == 0.5568

    evaluator = SynonymyEvaluator(
        strategy=ScoreStrategyEnum(ScoreStrategyEnum.MEAN),
        industry_name_embs=load_industry_names_embs(),
    )
    result = round(
        evaluator.evaluate(keyword),
        4,
    )
    assert isinstance(result, float)
    assert result == 0.4049
