from apadata.models import Keyword
from apadata.text_processors.keywords.enrichers.case_insensitive_finder_enricher import (
    CaseInsensitiveFinderEnricher,
)
from apadata.text_processors.keywords.reducers.case_insensitive_finder_reducer import (
    CaseInsensitiveFinderReducer,
)


def test_case_insensitive_finder_reducer():
    keyword = "consulting"
    finder = CaseInsensitiveFinderReducer(keyword)
    finder.process()
    keyword_objects = Keyword.objects.filter(name__iexact=keyword)
    discarded_list = [keyword_object.discarded for keyword_object in keyword_objects]
    assert all([isinstance(elem, bool) for elem in discarded_list])
    assert discarded_list.count(False) == 0


def test_case_insensitive_finder_enricher():
    keyword = "consulting"
    finder = CaseInsensitiveFinderEnricher(keyword)
    assert finder.process() == ["CONSULTING"]
