from apadata.models import Keyword
from apadata.text_processors.keywords.enrichers.cross_translator_enricher import (
    CrossTranslatorEnricher,
)
from apadata.text_processors.keywords.reducers.cross_translator_reducer import (
    CrossTranslatorReducer,
)


def test_cross_translator_reducer():
    keyword = "Verwaltung"
    cross_translator = CrossTranslatorReducer(keyword)
    cross_translator.process()
    assert Keyword.objects.get(name="Administration").discarded is False
    assert Keyword.objects.get(name=keyword).discarded is True


def test_cross_translator_enricher():
    keyword = "Verwaltung"
    CrossTranslatorEnricher(keyword).process()
    assert Keyword.objects.get(name="Administration").discarded is False
    assert Keyword.objects.get(name=keyword).discarded is False
