from apadata.models import Keyword
from apadata.text_processors.keywords.enrichers.deacronymizer_enricher import (
    DeacronymizerEnricher,
)
from apadata.text_processors.keywords.reducers.deacronymizer_reducer import (
    DeacronymizerReducer,
)


def test_deacronymizer_reducer():
    keyword = "BEL"
    deacronymizer = DeacronymizerReducer(keyword)
    deacronymizer.process()
    assert Keyword.objects.get(name="Bharat Electronics Limited").discarded is False
    assert Keyword.objects.get(name=keyword).discarded is True


def test_deacronymizer_enricher():
    keyword = "BEL"
    deacronymizer = DeacronymizerEnricher(keyword)
    deacronymizer.process()
    assert Keyword.objects.get(name="Bharat Electronics Limited").discarded is False
    assert Keyword.objects.get(name=keyword).discarded is False
