from apadata.models import Keyword
from apadata.text_processors.keywords.enrichers.lemma_finder_enricher import (
    LemmaFinderEnricher,
)
from apadata.text_processors.keywords.reducers.lemma_finder_reducer import (
    LemmaFinderReducer,
)


def test_lemma_finder_reducer():
    keyword = "Consulting"
    finder = LemmaFinderReducer(keyword)
    finder.process()
    assert Keyword.objects.get(name="Consultancy").discarded is True
    assert Keyword.objects.get(name=keyword).discarded is False


def test_lemma_finder_enricher():
    keyword = "Consulting"
    finder = LemmaFinderEnricher(keyword)
    assert finder.process() == {"Consultings", "Consultinging", "Consulting"}
