from apadata.text_processors.keywords.enrichers.similarity_finder_enricher import (
    SimilarityFinderEnricher,
)
from apadata.text_processors.keywords.reducers.similarity_finder_reducer import (
    SimilarityFinderReducer,
)


def test_similarity_finder_enricher():
    finder = SimilarityFinderEnricher("Consulting")
    removed_keywords = finder.process()
    assert removed_keywords == {
        "CONSULTING",
        "Consultancy",
        "Consulting",
        "Consultinging",
        "Consultings",
        "consultancy",
        "consulting",
        "consultinging",
        "consultings",
    }


def test_similarity_finder_reducer():
    finder = SimilarityFinderReducer("Consulting")
    removed_keywords = finder.process()
    assert removed_keywords == {
        "CONSULTING",
        "Consultancy",
        "Consulting",
        "Consultinging",
        "Consultings",
        "consultancy",
        "consulting",
        "consultinging",
        "consultings",
    }
