from apadata.models import Keyword
from apadata.text_processors.keywords.enrichers.synonymy_finder_enricher import (
    SynonymyFinderEnricher,
)
from apadata.text_processors.keywords.reducers.synonymy_finder_reducer import (
    SynonymyFinderReducer,
)


def test_synonymy_finder_reducer():
    keyword = "Consulting"
    finder = SynonymyFinderReducer(keyword)
    finder.process()
    assert Keyword.objects.get(name="Consulting").discarded is False
    assert Keyword.objects.get(name="consult").discarded is True

    keyword = "consult"
    finder = SynonymyFinderReducer(keyword)
    finder.process()
    assert Keyword.objects.get(name="consult").discarded is True
    assert Keyword.objects.get(name="Consulting").discarded is False


def test_synonymy_finder_enricher():
    keyword = "Consulting"
    finder = SynonymyFinderEnricher(keyword)
    finder.process()
    keywords = ["refer", "confabulate", "confab", "confer", "look_up", "confer_with"]
    for keyword in keywords:
        assert Keyword.objects.get(name=keyword)
