from unittest.mock import patch

import pytest

from ..text_translator import TextTranslator

TRANSLATION = "Weiter so! Du bist großartig!"


@pytest.mark.parametrize(
    "inputs",
    [
        [TRANSLATION, None, None, True],
        [None, TRANSLATION, None, True],
        [None, None, TRANSLATION, True],
        [None, None, None, False],
    ],
)
@patch("goslate.Goslate.translate")
@patch("deep_translator.GoogleTranslator.translate")
@patch("translate.Translator.translate")
def test_text_translator(mock_slate, mock_google, mock_translator, inputs):
    first_translation, second_translation, third_translation, valid_translation = inputs
    mock_slate.return_value = first_translation
    mock_google.return_value = second_translation
    mock_translator.return_value = third_translation
    text = "Keep it up! You are amazing!"
    translator = TextTranslator(
        source_language="en", destination_language="de", text=text
    )
    translated, is_translated = translator.translate_text()
    assert translated == translated
    assert is_translated is valid_translation

    translated, is_translated = translator.process()
    assert translated == translated
    assert is_translated is valid_translation
