from unittest.mock import patch

from apadata.text_processors.text_embedder_processor import TextEmbedderProcessor
from apadata.vectordb.vectordb_api import VectorDBAPI


@patch("apadata.vectordb.vectordb_api.VectorDBAPI.query")
def test_vector_db_api(mock_query):
    expected_result = {
        "matches": [{"id": "consulting", "score": 0.83645, "values": []}],
        "namespace": "",
    }
    mock_query.return_value = expected_result
    vector_db_api = VectorDBAPI()
    vector_db_api.insert(
        text="consulting", embedding=TextEmbedderProcessor("consulting").process()
    )
    vector_db_api.insert(
        text="engineering", embedding=TextEmbedderProcessor("engineering").process()
    )
    embedding = TextEmbedderProcessor("consultancy").process()
    result = vector_db_api.query(embedding=embedding, top_k=1)
    assert isinstance(result, dict)
    assert result == expected_result
