import json
import os

import pytest

from ..json_loader import JSONLoader


def test_json_loader():
    """Test JSONLoader"""
    unexistent_filepath = "loaders/tests/a.json"
    if os.path.exists(os.path.join("apadata", unexistent_filepath)):
        os.remove(os.path.join("apadata", unexistent_filepath))

    loader = JSONLoader(filepath=unexistent_filepath)
    with pytest.raises(ValueError):
        loader.save()

    loader = JSONLoader(filepath=unexistent_filepath, data=[1, 2])
    loader.save()

    if os.path.exists(os.path.join("apadata", unexistent_filepath)):
        os.remove(os.path.join("apadata", unexistent_filepath))

    loader = JSONLoader(filepath="loaders/tests/dummy_json.json")
    loader.load()

    with pytest.raises(json.decoder.JSONDecodeError):
        loader = JSONLoader(filepath="loaders/tests/dummy_json_broken.json")
        loader.load()

    assert not loader.list()
