from urllib.parse import urlparse

import tldextract
from django.db import models


class Domain(models.Model):
    """Model that contains the domain"""

    domain = models.CharField(max_length=255, primary_key=True)
    target_industries = models.ManyToManyField(
        "Industry", related_name="domains", through="DomainTargetIndustries"
    )

    @staticmethod
    def tld_extract(url):
        url_parsed = urlparse(url)
        parts = tldextract.extract(url_parsed.netloc or url_parsed.path)
        domain = parts.domain + "." + parts.suffix
        return domain
