from django.db import models

from apadata.models.domain import Domain
from apadata.models.industry import Industry


class DomainTargetIndustries(models.Model):
    """Persists the result computed by the target industry pipeline given a domain"""

    domain = models.ForeignKey(
        Domain,
        on_delete=models.CASCADE,
    )
    target_industries = models.ForeignKey(
        Industry,
        on_delete=models.CASCADE,
    )
    created_at = models.DateField(auto_now_add=True)
    last_updated_at = models.DateField(auto_now=True)
