from typing import Any, Dict

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule
from apadata.text_processors.evaluators.elasticsearch_evaluator import (
    ElasticsearchEvaluator,
)

Input = Dict[str, Any]
Output = Dict[str, Any]


class ElasticsearchEvaluatorModule(PipelineModule[Input, Output]):
    """Class for instantiating an object"""

    def __init__(
        self,
        name: str = "elasticsearch_evaluator",
        **kwargs: Any,
    ):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        keyword = context.search_field("keyword")
        evaluator = ElasticsearchEvaluator(
            all_keywords_list=context.search_field("green_list", [])
        )
        score = evaluator.evaluate(keyword)
        context.add("elasticsearch_score", score)
        return dict(context.payload)
