from typing import Any, Dict

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule
from apadata.text_processors.evaluators.generality_evaluator import GeneralityEvaluator

Input = Dict[str, Any]
Output = Dict[str, Any]


class GeneralityEvaluatorModule(PipelineModule[Input, Output]):
    """Class for instantiating GeneralityEvaluator object.
    This evaluator computes how specific are the words composing the keyword.
    @return: generality_score(float) - score of this evaluator in the context dict"""

    def __init__(
        self,
        name: str = "generality_evaluator",
        **kwargs: Any,
    ):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        keyword = context.search_field("keyword")
        evaluator = GeneralityEvaluator()
        score = evaluator.evaluate(keyword)
        context.add("generality_score", score)
        return dict(context.payload)
