from typing import Any, Dict

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule
from apadata.text_processors.evaluators.length_evaluator import LengthEvaluator

Input = Dict[str, Any]
Output = Dict[str, Any]


class LengthEvaluatorModule(PipelineModule[Input, Output]):
    """Class for instantiating LengthEvaluator object.
    This evaluator computes if the length of the keyword is optimal.
    @return: length_score(float) - score of this evaluator in the context dict"""

    def __init__(
        self,
        name: str = "length_evaluator",
        **kwargs: Any,
    ):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        keyword = context.search_field("keyword")
        min_keyword_length = context.search_field("minimum_length", 4)
        max_keyword_length = context.search_field("maximum_length", 40)
        evaluator = LengthEvaluator(
            min_length=min_keyword_length, max_length=max_keyword_length
        )
        score = evaluator.evaluate(keyword)
        context.add("length_score", score)
        return dict(context.payload)
