from typing import Any, Dict

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule
from apadata.text_processors.evaluators.location_evaluator import LocationEvaluator

Input = Dict[str, Any]
Output = Dict[str, Any]


class LocationEvaluatorModule(PipelineModule[Input, Output]):
    """Class for instantiating LocationEvaluator object.
    This evaluator checks that no country is mentioned in the keyword.
    @return: location_score(float) - score of this evaluator in the context dict"""

    def __init__(
        self,
        name: str = "location_evaluator",
        **kwargs: Any,
    ):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        keyword = context.search_field("keyword")
        evaluator = LocationEvaluator()
        score = evaluator.evaluate(keyword)
        context.add("location_score", score)
        return dict(context.payload)
