from typing import Any, Dict

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule
from apadata.text_processors.evaluators.low_quality_keywords_evaluator import (
    LowQualityKeywordsEvaluator,
)

Input = Dict[str, Any]
Output = Dict[str, Any]


class LowQualityKeywordsEvaluatorModule(PipelineModule[Input, Output]):
    """Class for instantiating LowQualityEvaluator object.
    This evaluator computes the quality of the keyword by assessing the presence of
    special characters and blacklisted words.
    @return: low_quality_keywords_score(float) - score of this evaluator in the
    context dict"""

    def __init__(
        self,
        name: str = "low_quality_evaluator",
        **kwargs: Any,
    ):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        keyword = context.search_field("keyword")
        evaluator = LowQualityKeywordsEvaluator()
        score = evaluator.evaluate(keyword)
        context.add("low_quality_keywords_score", score)
        return dict(context.payload)
