from typing import Any, Dict

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule
from apadata.text_processors.evaluators.spelling_evaluator import SpellingEvaluator

Input = Dict[str, Any]
Output = Dict[str, Any]


class SpellingEvaluatorModule(PipelineModule[Input, Output]):
    """Class for instantiating an object"""

    def __init__(
        self,
        name: str = "spelling_evaluator",
        **kwargs: Any,
    ):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        keyword = context.search_field("keyword")
        language = context.search_field("language")
        evaluator = SpellingEvaluator()
        score = evaluator.evaluate(keyword, language=language)
        context.add("spelling_score", score)
        return dict(context.payload)
