from typing import Any, Dict

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule
from apadata.text_processors.evaluators.synonymy_evaluator import SynonymyEvaluator

Input = Dict[str, Any]
Output = Dict[str, Any]


class SynonymyEvaluatorModule(PipelineModule[Input, Output]):
    """Class for instantiating an object"""

    def __init__(
        self,
        name: str = "synonymy_evaluator",
        **kwargs: Any,
    ):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        keyword = context.search_field("keyword")
        evaluator = SynonymyEvaluator()
        score = evaluator.evaluate(keyword)
        context.add("synonymy_score", score)
        return dict(context.payload)
