from typing import Any, Dict, Union

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule
from apadata.text_processors.lang_detect_text_processor import LangDetectTextProcessor

Input = Union[str, Dict[str, Any]]
Output = Union[str, Dict[str, Any]]


class LangDetectTextProcessorModule(PipelineModule[Input, Output]):
    """Class for instantiating LanguageDetector object"""

    def __init__(self, name: str = "language", **kwargs: Any):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        payload: Union[str, Dict[str, Any]] = context.payload
        if isinstance(payload, dict):
            text = payload["text"]
        elif isinstance(payload, str):
            text = payload
        else:
            raise ValueError("Payload should have been a dictionary")

        language_detector = LangDetectTextProcessor(text=text)
        detected_lang = language_detector.detect()
        context.add("language", detected_lang)
        return payload
