from apadata.modules.evaluators.generality_evaluator_module import (
    GeneralityEvaluatorModule,
)
from apadata.pipelines.pipeline_context import PipelineContext


def test_generality_evaluator_module():
    payload = {"keyword": "Consulting"}
    context = PipelineContext(payload=payload)
    module = GeneralityEvaluatorModule()
    module.run(context)
    assert context.search_field("generality_score") > 0.5

    payload = {"keyword": "Stuff"}
    context = PipelineContext(payload=payload)
    module = GeneralityEvaluatorModule()
    module.run(context)
    assert context.search_field("generality_score") < 0.5
