from apadata.modules.evaluators.length_evaluator_module import LengthEvaluatorModule
from apadata.pipelines.pipeline_context import PipelineContext


def test_length_evaluator_module():
    payload = {"keyword": "Consulting"}
    context = PipelineContext(payload=payload)
    module = LengthEvaluatorModule()
    module.run(context)
    assert context.search_field("length_score") == 1.0

    payload = {"keyword": "lol"}
    context = PipelineContext(payload=payload)
    module = LengthEvaluatorModule()
    module.run(context)
    assert context.search_field("length_score") == 0.0
