from apadata.modules.evaluators.low_quality_keywords_evaluator_module import (
    LowQualityKeywordsEvaluatorModule,
)
from apadata.pipelines.pipeline_context import PipelineContext


def test_low_quality_keywords_evaluator_module():
    payload = {"keyword": "Consulting"}
    context = PipelineContext(payload=payload)
    module = LowQualityKeywordsEvaluatorModule()
    module.run(context)
    assert context.search_field("low_quality_keywords_score") == 1.0

    payload = {"keyword": "Consulting United States of America and with stupid idiot"}
    context = PipelineContext(payload=payload)
    module = LowQualityKeywordsEvaluatorModule()
    module.run(context)
    assert context.search_field("low_quality_keywords_score") < 1.0
