from unittest.mock import patch

from apadata.modules.chat_gpt_module import ChatGptModule
from apadata.pipelines.pipeline_context import PipelineContext


@patch("apadata.chatgpt.chat_gpt.openai")
def test_chat_gpt_module(mock_openai):
    mock_response = {
        "choices": [
            {"message": {"role": "mock-role", "content": "this is a mock message"}}
        ]
    }
    mock_openai.ChatCompletion.create.return_value = mock_response

    payload = {
        "company_name": "apadua",
        "keyword": "gg",
        "text": "we are apadua",
    }

    context = PipelineContext(payload=payload)
    context.add("temperature", 2.0)
    context.add("prompt_index", 0)
    gpt_module: ChatGptModule = ChatGptModule()
    module_output = gpt_module.run(context)
    assert module_output == "this is a mock message"
