from unittest.mock import patch

from apadata.pipelines.pipeline_context import PipelineContext

from ..elasticsearch_client_module import ElasticsearchClientModule

dummy_text = [
    "Accenture web content line 1",
    "Accenture web content line 2",
    "Accenture web content line 3",
]


class MockESClient:
    """Mocked ES client base class to be used with context managers"""

    @staticmethod
    def search(domain, keyword, size, url):
        assert domain == "accenture.com"
        assert keyword == ""
        assert size > 0
        assert url == "accenture.com"
        return []

    @staticmethod
    def get_web_contents(hits):
        return dummy_text


@patch("apadata.modules.elasticsearch_client_module.ElasticsearchClient")
def test_elasticsearch_client_module(mock_es_client):
    mock_es_client.return_value = MockESClient
    domain = "accenture.com"
    payload = {"domain": f"{domain}", "urls": [f"{domain}/about"]}
    context = PipelineContext(payload=payload)
    elastic_module: ElasticsearchClientModule = ElasticsearchClientModule()
    result = elastic_module.run(context)
    assert isinstance(result, dict)
    assert len(result) == 1
    assert "text" in result.keys()
    assert isinstance(result["text"], str)
    assert len(result["text"]) > 0
    assert result["text"] == "\n§\n".join(dummy_text)
