from ...pipelines.pipeline_context import PipelineContext
from ..spacy_text_processor_module import SpacyTextProcessorModule


def test_spacy_text_processor_module():
    payload = {"text": "He works for Apple since the year 2015", "language": "en"}
    context = PipelineContext(payload=payload)
    spacy_client_module: SpacyTextProcessorModule = SpacyTextProcessorModule()
    spacy_client_module.run(context)
    assert context.get("company_names") == ["Apple"]

    new_payload = "He works for Apple since the year 2015"
    context = PipelineContext(payload=new_payload)
    context.add("language", "en")
    spacy_client_module.run(context)
    assert context.get("company_names") == ["Apple"]
