from apadata.modules.chat_gpt_module import ChatGptModule
from apadata.modules.elasticsearch_client_module import ElasticsearchClientModule
from apadata.pipelines.pipeline import Pipeline
from apadata.pipelines.pipeline_context import PipelineContext


def move_payload_to_context(context):
    company_name = context.search_field("company_name")
    keyword = context.search_field("keyword")
    domain = context.search_field("domain")

    context.add("company_name", company_name)
    context.add("keyword", keyword)
    context.add("domain", domain)

    return context


class SummariesPipeline(Pipeline):
    """
    A pipeline for summarizing company content.
    This pipeline is designed to automatically generate concise summaries of
    company web content centered around important domain keywords using ChatGpt.

    @param context:Dict[str, Any] - contains input payload with a companies name,
    domain and keyword
    @return: str - summary
    """

    def __init__(
        self,
        context: PipelineContext,
    ):
        super().__init__(
            context,
            [
                ElasticsearchClientModule(pre_process=move_payload_to_context),
                ChatGptModule(),
            ],
        )
