from unittest.mock import patch

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.summaries_pipeline import SummariesPipeline


class MockESClient:
    """Mocked ES client base class to be used with context managers"""

    @staticmethod
    def search(domain, keyword, size, url):
        return []

    @staticmethod
    def get_web_contents(hits):
        return ["we are apadua"]


@patch("apadata.chatgpt.chat_gpt.openai")
@patch("apadata.modules.elasticsearch_client_module.ElasticsearchClient")
def test_summaries_pipeline(mock_elastic, mock_openai):
    mock_response = {
        "choices": [
            {"message": {"role": "mock-role", "content": "this is a mock message"}}
        ]
    }
    mock_openai.ChatCompletion.create.return_value = mock_response
    mock_elastic.return_value = MockESClient
    payload = {
        "company_name": "apadua",
        "keyword": "cool",
        "domain": "apadua.de",
    }

    context = PipelineContext(payload=payload)
    summaries_pipeline = SummariesPipeline(context=context)
    pipeline_output = summaries_pipeline.run()
    assert pipeline_output.result == "this is a mock message"
