from os import environ, path

import sentry_sdk
from sentry_sdk.integrations.django import DjangoIntegration

from apadata.constants import DATABASE_DIR, ENVIRONMENT, SENTRY_DSN

DEBUG = environ.get("DJANGO_DEBUG", False)

INSTALLED_APPS = ["apadata.apps.ApadataConfig"]

DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": path.join(DATABASE_DIR, "apadata_local.db"),
    },
}

# Redis Caching
CACHES = {
    "default": {
        "BACKEND": "django_redis.cache.RedisCache",
        "LOCATION": "redis://127.0.0.1:6379/1",
        "OPTIONS": {"CLIENT_CLASS": "django_redis.client.DefaultClient"},
        "KEY_PREFIX": "apadata",
    }
}
# Cache time to live is 15 minutes.
CACHE_TTL = 60 * 15

RQ = {
    "DEFAULT_RESULT_TTL": 60_000,
}

RQ_QUEUES = {
    "default": {
        "USE_REDIS_CACHE": "default",
    },
    "high": {
        "USE_REDIS_CACHE": "default",
    },
    "low": {
        "USE_REDIS_CACHE": "default",
    },
}


LOGGING = {
    "version": 1,
    "filters": {
        "require_debug_true": {
            "()": "django.utils.log.RequireDebugTrue",
        }
    },
    "handlers": {
        "console": {
            "level": "DEBUG",
            "filters": ["require_debug_true"],
            "class": "logging.StreamHandler",
        }
    },
    "loggers": {
        "django.db.backends": {
            "level": "DEBUG",
            "handlers": ["console"],
        }
    },
}

# Type of field to use for auto-created primary keys fields in Django models.
DEFAULT_AUTO_FIELD = "django.db.models.AutoField"

USE_TZ = False

############################################
# Sentry configuration
if ENVIRONMENT != "development":
    sentry_sdk.init(
        dsn=environ.get("SENTRY_DSN", SENTRY_DSN),
        integrations=[DjangoIntegration()],
        # Set traces_sample_rate to 1.0 to capture 100%
        # of transactions for performance monitoring.
        # We recommend adjusting this value in production.
        traces_sample_rate=1.0,
        # If you wish to associate users to errors (assuming you are using
        # django.contrib.auth) you may enable sending PII data.
        send_default_pii=True,
    )


###################################
# Debug mode configuration
if DEBUG:
    for queueConfig in RQ_QUEUES.values():
        queueConfig["ASYNC"] = "False"
