from .highest_score_strategy import HighestScoreStrategy
from .mean_score_strategy import MeanScoreStrategy
from .score_strategy import ScoreStrategy, ScoreStrategyEnum


class ScoreStrategyFactory:
    """Factory class for our ScoreStrategy class"""

    STRATEGIES = {
        ScoreStrategyEnum.MEAN: MeanScoreStrategy,
        ScoreStrategyEnum.HIGHEST: HighestScoreStrategy,
    }

    @staticmethod
    def create(strategy: ScoreStrategyEnum) -> ScoreStrategy:
        return ScoreStrategyFactory.STRATEGIES[strategy]()
