from django.db import models
from structlog import get_logger

from apadata.models import Domain, Summary
from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.summaries_pipeline import SummariesPipeline

logger = get_logger(__name__)


def extract_summary_task(
    *,
    domain: str,
    company: str,
    keyword: str,
    recalculate: bool = False,
    prompt_index: int = 0,
) -> str:

    domain = Domain.tld_extract(domain)
    try:
        domain_object = Domain.objects.get(domain=domain)
    except models.ObjectDoesNotExist:
        domain_object = Domain.objects.create(domain=domain)

    try:
        summary = Summary.objects.get(
            company=company, keyword=keyword, domain=domain_object
        )
        if not recalculate:
            return str(summary.text)
    except models.ObjectDoesNotExist:
        summary = Summary(company=company, keyword=keyword, domain=domain_object)

    payload = {
        "company_name": company,
        "keyword": keyword,
        "domain": domain,
    }
    context = PipelineContext(payload=payload)
    context.add("prompt_index", prompt_index)
    summaries_pipeline = SummariesPipeline(context=context)
    pipeline_context = summaries_pipeline.run()
    result = pipeline_context.result

    summary.text = result
    summary.save()

    return str(result)
