from dataclasses import dataclass
from unittest.mock import patch

from apadata.models import Summary
from apadata.tasks import extract_summary_task


@dataclass
class TestResult:
    result: str


@patch("apadata.pipelines.pipeline.Pipeline.run")
def test_extract_summary_task(mock_run):
    mock_run.return_value = TestResult(result="skibidi bop")
    test_company = "accenture"
    test_keyword = "Audit"
    test_domain = "accenture.com"
    result = extract_summary_task(
        company=test_company, keyword=test_keyword, domain=test_domain
    )
    assert result == "skibidi bop"
    assert (
        Summary.objects.get(company=test_company, keyword=test_keyword).text == result
    )
