# DJANGO_SETTINGS_MODULE=apadata.settings (either we do this)
#  either manage.py (which automatically loads the settings file)
from typing import Dict, List

from dataclasses import dataclass
from unittest.mock import patch

from apadata.tasks import target_industries_task


@dataclass
class TestResult:
    result: Dict[str, List[str]]


@patch("apadata.pipelines.pipeline.Pipeline.run")
def test_target_industries_task(mock_run):
    mock_run.return_value = TestResult(
        result={"target_industries": ["mining", "fishing"]}
    )
    test_domain = "kearney.com"
    result = target_industries_task(domain=test_domain)
    assert sorted(result) == sorted(["mining", "fishing"])
