from typing import Any

import abc


class Evaluator:
    """
    Abstract class for creating evaluators that evaluate keywords
    """

    @abc.abstractmethod
    def evaluate(self, keyword: str, **kwargs: Any) -> float:
        """
        Parameters
        ----------
        keyword: str
            The keyword which will be evaluated and based on this a float normalized
            score between 0.0 and 1.0 will be computed
        """
