# pylint: disable-all
from typing import Any

from spellchecker import SpellChecker

from apadata.text_processors import LangDetectTextProcessor
from apadata.text_processors.evaluators.evaluator import Evaluator


class SpellingEvaluator(Evaluator):
    def evaluate(self, keyword: str, **kwargs: Any) -> float:
        language = kwargs["language"]
        if not language:
            language = LangDetectTextProcessor(keyword).detect()
        if not language:
            return 1.0
        try:
            spell_checker = SpellChecker(language=language)
        except ValueError:
            return 1.0
        if spell_checker.correction(keyword) != keyword:
            return 0.0
        return 1.0
