from typing import Optional

from functools import lru_cache

from langdetect import detect

from .text_processor import TextProcessor


@lru_cache
def detect_language(text: str) -> Optional[str]:
    result = detect(text)
    return str(result) if result else None


class LangDetectTextProcessor(TextProcessor):
    """
    This class will detect the language
    """

    def detect(self) -> Optional[str]:
        if not self.text:
            raise ValueError("Text cannot be empty string or None")
        return detect_language(self.text)
