from typing import Any

from apadata.text_processors.evaluators.evaluator import Evaluator


class MockLengthEvaluator(Evaluator):
    def evaluate(self, keyword: str, **kwargs: Any) -> float:
        if len(keyword) < 4 or len(keyword) > 60:
            return 0.0
        return 1.0


def test_evaluator():
    evaluator = MockLengthEvaluator()
    assert evaluator.evaluate("abracadabra") == 1.0
    assert evaluator.evaluate("abr") == 0.0
