from apadata.strategies.score_strategy import ScoreStrategyEnum
from apadata.text_processors.evaluators.synonymy_evaluator import SynonymyEvaluator


def test_synonymy_evaluator():
    evaluator = SynonymyEvaluator(strategy=ScoreStrategyEnum(ScoreStrategyEnum.HIGHEST))
    keyword = "Consulting"
    result = round(
        evaluator.evaluate(keyword),
        4,
    )
    assert isinstance(result, float)
    assert result == 0.466

    evaluator = SynonymyEvaluator(strategy=ScoreStrategyEnum(ScoreStrategyEnum.MEAN))
    result = round(
        evaluator.evaluate(keyword),
        4,
    )
    assert isinstance(result, float)
    assert result == 0.2621
