from unittest.mock import patch

from apadata.text_processors.evaluators.wikipedia_evaluator import WikipediaEvaluator


@patch("apadata.text_processors.evaluators.wikipedia_evaluator.wikipedia.search")
def test_wikipedia_evaluator(mock_wikipedia):
    mock_wikipedia.return_value = ["Wikipedia Title 1"]
    evaluator = WikipediaEvaluator(
        search_all_queries_permutations=False, suggestion=False
    )
    keyword = "Biotechnology"
    assert (
        evaluator.evaluate(
            keyword,
        )
        == 1.0
    )

    evaluator = WikipediaEvaluator(suggestion=True)
    keyword = "Consutlingx"
    assert evaluator.evaluate(keyword) == 1.0
