from unittest.mock import patch

from ..text_translator import TextTranslator


@patch("apadata.text_processors.text_translator.TextTranslator.translate_goslate")
def test_text_translator(mock_tt):
    translation = "Weiter so! Du bist großartig!"
    mock_tt.return_value = translation
    text = "Keep it up! You are amazing!"
    translator = TextTranslator(
        source_language="en", destination_language="de", text=text
    )
    translated, is_translated = translator.translate_text()
    assert translated == translation
    assert is_translated is True
